;------------------------------------------------------------------------------
;                         SoftIce 95 helper VxD skeleton
;				       written by Iceman
;------------------------------------------------------------------------------
.486p
include basedef.inc
include vmm.inc
include vwin32.inc
include debug.inc


Id EQU 808h 		;device driver unique Id nr WATCH OUT this is NOT an official ID!!!
			;may exist another VxD whith this "unique" ID!!!!!
			;if you extend this skeleton please change it!!
;-----------------------------------------------------------------------------------------------
;				Virtual Device Declaration
;-----------------------------------------------------------------------------------------------


Declare_Virtual_Device ICECMD, 1, 0, vxd_control, Id , Undefined_Init_Order

;-----------------------------------------------------------------------------------------------
;				      Locked data segment	
;-----------------------------------------------------------------------------------------------



VxD_LOCKED_DATA_SEG

help db ".Z - Various system info services.Type ' .Z?' for more information." , 13

VxD_LOCKED_DATA_ENDS

;-----------------------------------------------------------------------------------------------
;					Locked code segment
;				  Contain driver control procedure 
;-----------------------------------------------------------------------------------------------
VxD_LOCKED_CODE_SEG

BeginProc vxd_control

	Control_Dispatch Debug_Query , on_debug_query
	Control_Dispatch Device_Init,  on_device_init	
	clc
	ret

EndProc vxd_control


BeginProc on_debug_query

begin:	 Trace_Out " "	
	 Trace_Out "**************Iceman's debug options***************"
	 Trace_Out "---------------------------------------------------"	
	 Trace_Out "DO press Ctrl+D at this time.Your machine may hang."
	 Trace_Out "---------------------------------------------------"
	 Trace_Out "[1] Set 1st Mb Memory Arena Stauts"
	 Trace_Out "Please enter your selection (ESC quits):" , nocrlf
	 VmmCall In_Debug_Chr		;get char pressed in al
	 jz done			;was ESC pressed ?
	 Trace_Out " "  
	 cmp al , '1'			
	 jz first_mb
	 Trace_Out "Invalid command"
	 jmp begin

first_mb:
	Trace_Out " "
	Trace_Out "----------------------------"
	Trace_Out " 1st Mb Memory Arena Options"
	Trace_Out "----------------------------"
	Trace_Out "[1] to enable touching 1st Mb"
	Trace_Out "[2] to disable touching 1st Mb"
	Trace_Out "Please enter your selection (ESC quits):" , nocrlf
	VmmCall In_Debug_Chr
	jz done	
	Trace_Out " "  
	cmp al , '1'
	jz first_enable
	cmp al , '2'
	jz first_disable
	Trace_Out "Invalid command"
	jmp first_mb

first_enable:
	Begin_Touch_1st_Meg
	Trace_Out "1st Mb memory range forced present."
	Trace_Out "VxD can access this range now."
	jmp done
first_disable:
	End_Touch_1st_Meg
	Trace_Out "1st Mb memory range returned to normal state"
	jmp done
done:
	clc
	ret
	
EndProc on_debug_query


BeginProc on_Idot_command
    mov ax,77h					
    mov bl , 1					 ;skip leading blank			
    int 41h	 				 ;GetCommandLineChar
    cmp al , '?'			         ; Want help ?				      
    jz help_z
    cmp al , 's'				 ; Want stack dump?
    jz stack_dump					      
    cmp al , 'S'			         ; Idem
    jz stack_dump 
    jmp cmd_error		                 ; not a valid command? 
help_z:
    Trace_Out " Syntax - .Z<command> <param1> <param2> <param3>"
    Trace_Out "	Where command can be:"
    Trace_Out "	S - Perform a stack dump.Type of dump is choosed by <param1>"
    Trace_Out "         <1> performs a 16 bit stack dump"
    Trace_Out "         <2> performs a 32 bit stack dump"
    Trace_Out "         <3> performes a verbose stack dump"
    Trace_Out "		<param2> and <param3> are ignored"
    jmp end_doti  
stack_dump:
    mov ax , 77h
    mov bl , 1h
    int 41h
    cmp al ,'1'
    jz 	stack_16
    cmp al ,'2'
    jz  stack_32 	
    cmp al ,'3'	
    jz verbose
    jmp cmd_error		 
stack_16:
    mov ax , 7bh
    mov bx , 2h
    int 41h
    jmp end_doti			
stack_32:
    mov ax , 7bh
    mov bx , 4h
    int 41h
    jmp end_doti		
verbose:		           					 
    mov ax , 7bh				      ;stack dump subfunction
    mov bx , 1h					      ;verbose stack dump
    int 41h
    jmp end_doti

cmd_error:
    Trace_Out " "	
    Trace_Out "You have not entered a valid command! .Z? for help!"			      
    mov eax , 1h				      ;we land here if some error occures 
						      ;(eax != 0 ) to indicate failure on dot
						      ;command routine	error code in EAX 	
    retf	 				      ;MUST return whith a FAR 32 bit return	
end_doti:
    mov eax , 0h				      ;(eax == ) to indicate success  	
    retf					      ;MUST return whith a FAR 32 bit return	

EndProc on_Idot_command

VxD_LOCKED_CODE_ENDS

;-----------------------------------------------------------------------------------------------
;				    Initialization code segment
;				    Contain driver init procedure 
;				        Discareded after init			
;-----------------------------------------------------------------------------------------------
VxD_ICODE_SEG


BeginProc on_device_init

	VmmCall Test_Debug_Installed ; see if a kernel debuger 	is installed
	jz prevent_load;	     ;if not , no point in loading
				     ;if  a is not installed debuuger the next INT 41h
				     ;will cause a protection error , preventing Windows 95
				     ;to load		
	mov ax ,70h 		     ;register dot command function code in ax	
	mov bl , 'z'		     ;dot command to register goes in bl  	
	mov esi , offset32 cs:on_Idot_command   ;offset of dot command procedure
	mov edi , offset32 ds:help   ;offset of dot command help string
	int 41h			     ;Protected mode debugger interface	
				     ;WARNING! calling INT 41h whithout a debugger installed
				     ;cause protection faults. 
	cmp eax , 0		     ; (eax != 0) if registration failed	
	jz reg_done
	Trace_Out "An error has occured while triyng to register dot command" ;notify the user 
        jmp prevent_load
reg_done:
	clc			     ;clear carry to indicate no error	
	ret			     ;init phase complete ,VxD loaded , this code can be discarded	
prevent_load:
	stc			     ;set carry to indicate failure	
	ret			     ;init phase complete ,VxD not loaded	
EndProc   on_device_init

VxD_ICODE_ENDS
;-----------------------------------------------------------------------------------------------
;				Real Mode INIT Code Segment
;			   Contain VxD real mode init procedure
;-----------------------------------------------------------------------------------------------


VxD_REAL_INIT_SEG

BeginProc VxD_Real_Init_Proc

	test	bx, Duplicate_Device_ID ; check for duplicate id
	jnz	real_fail_load               ; fail virtual device loading if so

        mov     bx, 0h                  ; do not exclude any memory pages
        mov     si, 0h                  ; we do not have instance specific data
        mov     edx,0h                  ; pass nothing to protected mode init procedure

        mov     ax, Device_Load_Ok	; if it is not already loaded than do so
        ret

real_fail_load:
        mov     ax, Abort_Device_Load   ; inform OS that we do not want this VxD loaded
        ret				; return to OS loading code

EndProc VxD_Real_Init_Proc


VxD_REAL_INIT_ENDS





END

